/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.concurrent;

import net.za.pwnconsulting.javaconfig.concurrent.Sync;

public class Semaphore
implements Sync {
    protected long mPermits;
    protected long mOriginalPermits;

    public Semaphore(long pPermits) {
        this.mPermits = pPermits;
        this.mOriginalPermits = pPermits;
    }

    public synchronized void release() {
        if (this.mPermits + 1L > this.mOriginalPermits) {
            throw new IllegalStateException("Cannot release a semaphore more times than it was acquired");
        }
        ++this.mPermits;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.mPermits <= 0L) {
                    this.wait();
                }
                --this.mPermits;
            }
            catch (InterruptedException e) {
                this.notify();
                throw e;
            }
        }
    }

    public boolean attempt(long pMilliseconds) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.mPermits > 0L) {
                --this.mPermits;
                return true;
            }
            if (pMilliseconds <= 0L) {
                return false;
            }
            try {
                long vNow;
                long vStartTime = System.currentTimeMillis();
                long vWaitTime = pMilliseconds;
                do {
                    this.wait(vWaitTime);
                    if (this.mPermits <= 0L) continue;
                    --this.mPermits;
                    return true;
                } while ((vWaitTime = pMilliseconds - ((vNow = System.currentTimeMillis()) - vStartTime)) > 0L);
                return false;
            }
            catch (InterruptedException e) {
                this.notify();
                throw e;
            }
        }
    }

    public synchronized boolean isActive() {
        return this.mPermits < this.mOriginalPermits;
    }
}

