/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.beans;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.javaconfig.beans.CoercionException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeNestedException;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.log4j.Logger;

public class Coercions {
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    private final String mDateFormat;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    private final boolean mDateFormatNotSpecified;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Date;

    public Coercions() {
        this(null);
    }

    public Coercions(String pDateFormat) {
        if (Utils.isEmptyString(pDateFormat)) {
            this.mDateFormat = DEFAULT_DATE_FORMAT;
            this.mDateFormatNotSpecified = true;
        } else {
            this.mDateFormat = pDateFormat;
            this.mDateFormatNotSpecified = false;
        }
    }

    public Object coerceString(String pValue, Class pDesiredType) throws CoercionException {
        try {
            Object vRes = null;
            if (pDesiredType.isPrimitive() && (pValue == null || pValue.equals(""))) {
                throw new CoercionException("Cannot convert a null or empty value into a primitive type - field requires a value");
            }
            if (pDesiredType == null) {
                throw new RuntimeNestedException("The desired type class has not been specified");
            }
            if (pValue == null) {
                vRes = null;
            } else {
                if (pValue.equals("") && !pDesiredType.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = Coercions.class$("java.lang.String")) : class$java$lang$String)) {
                    return null;
                }
                if (pDesiredType.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pDesiredType.isAssignableFrom(Integer.TYPE)) {
                    vRes = new Integer(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pDesiredType.isAssignableFrom(Short.TYPE)) {
                    vRes = new Short(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || pDesiredType.isAssignableFrom(Long.TYPE)) {
                    vRes = new Long(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || pDesiredType.isAssignableFrom(Double.TYPE)) {
                    vRes = new Double(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pDesiredType.isAssignableFrom(Float.TYPE)) {
                    vRes = new Float(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Coercions.class$("java.lang.Boolean")) : class$java$lang$Boolean) || pDesiredType.isAssignableFrom(Boolean.TYPE)) {
                    vRes = pValue.equalsIgnoreCase("yes") || pValue.equalsIgnoreCase("1") || pValue.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || pDesiredType.isAssignableFrom(Character.TYPE)) {
                    if (pValue.length() > 1) {
                        throw new CoercionException("A string with length > 1 cannot be coerced into a character.");
                    }
                    vRes = new Character(pValue.charAt(0));
                } else if (pDesiredType.isAssignableFrom(class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pDesiredType.isAssignableFrom(Byte.TYPE)) {
                    vRes = new Byte(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Coercions.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    vRes = new BigDecimal(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$math$BigInteger == null ? (class$java$math$BigInteger = Coercions.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                    vRes = new BigInteger(pValue);
                } else if (pDesiredType.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = Coercions.class$("java.lang.String")) : class$java$lang$String)) {
                    vRes = pValue;
                } else if (pDesiredType.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = Coercions.class$("java.util.Date")) : class$java$util$Date)) {
                    if (this.mDateFormat == null || this.mDateFormat.equals("")) {
                        throw new CoercionException("Coercion class was not initialized properly as the DateFormat was not specified");
                    }
                    if (this.mDateFormatNotSpecified) {
                        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_JAVACONFIG, "No custom DateTimeFormat was specified in the configuration file - will fall back to default value [yyyy/MM/dd]");
                    }
                    SimpleDateFormat vSimpleDateFormat = new SimpleDateFormat(this.mDateFormat);
                    vSimpleDateFormat.setLenient(false);
                    vRes = vSimpleDateFormat.parse(pValue);
                } else {
                    PropertyEditor vPE = PropertyEditorManager.findEditor(pDesiredType);
                    if (vPE == null) {
                        throw new CoercionException("Could not find a property editor for the type [" + pDesiredType + "]");
                    }
                    vPE.setAsText(pValue);
                    vRes = vPE.getValue();
                }
            }
            return vRes;
        }
        catch (NumberFormatException e) {
            if (pValue.equals("")) {
                throw new CoercionException("No value was specified for conversion to type [" + pDesiredType.getName() + "]: " + e.getMessage(), e);
            }
            throw new CoercionException("Error in converting string value [" + pValue + "] to type [" + pDesiredType.getName() + "]: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            if (pValue.equals("")) {
                throw new CoercionException("No value was specified for conversion to type [" + pDesiredType.getName() + "]: " + e.getMessage(), e);
            }
            String vExtra = "";
            if (pDesiredType.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = Coercions.class$("java.util.Date")) : class$java$util$Date)) {
                vExtra = " - Require date in format [" + this.mDateFormat + "]";
            }
            throw new CoercionException("Error in converting string value [" + pValue + "] to type [" + pDesiredType.getName() + "] " + vExtra + ": " + e.getMessage(), e);
        }
    }

    public List coerceStrings(String[] pValue, Class pDesiredType) throws CoercionException {
        ArrayList<Object> vRes = new ArrayList<Object>();
        if (pValue == null) {
            vRes = null;
        } else {
            for (int i = 0; i < pValue.length; ++i) {
                vRes.add(this.coerceString(pValue[i], pDesiredType));
            }
        }
        return vRes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

