/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.javaconfig.beans;

import java.beans.Introspector;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.beans.BeanWrapper;
import net.za.pwnconsulting.javaconfig.beans.CoercionException;
import net.za.pwnconsulting.javaconfig.beans.Coercions;
import net.za.pwnconsulting.javaconfig.beans.Errors;
import net.za.pwnconsulting.javaconfig.beans.ReflectionBean;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.Configuration;
import net.za.pwnconsulting.javaconfig.core.ConfigurationAware;
import net.za.pwnconsulting.javaconfig.core.LMS;
import org.apache.log4j.Logger;

public class BeanFactory {
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());
    private Map mBeanCache;
    private Configuration mConfiguration;
    private Coercions mCoercions;
    private String mBeanFactoryName;
    static /* synthetic */ Class class$net$za$pwnconsulting$javaconfig$beans$ReflectionBean;
    static /* synthetic */ Class class$net$za$pwnconsulting$javaconfig$core$ConfigurationAware;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public BeanFactory(Configuration pConfiguration) {
        this.mConfiguration = pConfiguration;
        this.mBeanCache = new HashMap();
        this.mBeanFactoryName = "BF-" + pConfiguration.getClass().getName();
    }

    public void init() {
        String vDateFormat = this.mConfiguration.getSettings().getParameterByNameSilent("DateTimeFormat");
        this.mCoercions = new Coercions(vDateFormat);
    }

    protected void finalize() throws Throwable {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - BeanFactory Destroyed.");
        super.finalize();
    }

    private Object getBean(String pBeanName, Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        try {
            Object vBean = null;
            vBean = this.getBeanFromCache(pBeanName, pCompatibleClass, pIncompatibleClass);
            if (vBean == null) {
                throw new BeanFactoryException("Bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] was not found in the bean cache");
            }
            return vBean;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception for bean [" + pBeanName + "]: " + e.getMessage(), e);
        }
    }

    public Object getBean(String pBeanName, Class pCompatibleClass) throws BeanFactoryException {
        return this.getBean(pBeanName, pCompatibleClass, null);
    }

    public Object getBean(Class pCompatibleClass) throws BeanFactoryException {
        return this.getBean(null, pCompatibleClass, null);
    }

    public Object getBean(Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        return this.getBean(null, pCompatibleClass, pIncompatibleClass);
    }

    public boolean findBean(String pBeanName, Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        try {
            Object vBean = null;
            vBean = this.getBeanFromCache(pBeanName, pCompatibleClass, pIncompatibleClass);
            return vBean != null;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception: " + e.getMessage(), e);
        }
    }

    private void removeBean(String pBeanName, Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        try {
            this.removeBeanFromCache(pBeanName, pCompatibleClass, pIncompatibleClass);
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception for bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "]: " + e.getMessage(), e);
        }
    }

    public void removeBean(String pBeanName, Class pCompatibleClass) throws BeanFactoryException {
        this.removeBean(pBeanName, pCompatibleClass, null);
    }

    public void removeBean(Class pCompatibleClass) throws BeanFactoryException {
        this.removeBean(null, pCompatibleClass, null);
    }

    public void removeBean(Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        this.removeBean(null, pCompatibleClass, pIncompatibleClass);
    }

    public synchronized void addExistingBean(String pBeanName, Object pBean, Class pCompatibleClass, boolean pSingleton) throws BeanFactoryException {
        if (pBean == null) {
            throw new BeanFactoryException("Can not add a null bean to the cache");
        }
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - addExistingBean called for bean name [" + pBeanName + "], class name [" + pBean.getClass().getName() + "], compatible class [" + pCompatibleClass.getName() + "], singleton [" + pSingleton + "]");
            BeanWrapper vWrappedBean = new BeanWrapper(pBeanName, pBean, pCompatibleClass, pSingleton);
            this.mBeanCache.put(vWrappedBean.getBeanDefinition(), vWrappedBean);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - New Bean [" + vWrappedBean.getBeanDefinition() + "] was added to cache ");
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception for bean [" + pBeanName + "]: " + e.getMessage(), e);
        }
    }

    public synchronized Object createBean(String pBeanName, String pClassName, Class pCompatibleClass, boolean pSingleton) throws BeanFactoryException {
        try {
            Object vBean = null;
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - createBean called for bean name [" + pBeanName + "], class name [" + pClassName + "], compatible class [" + pCompatibleClass.getName() + "], singleton [" + pSingleton + "]");
            vBean = this.getBeanFromCache(pBeanName, pCompatibleClass, null);
            if (vBean != null) {
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Bean [" + vBean.getClass().getName() + "] retrieved from cache");
            }
            if (vBean != null && pSingleton) {
                BeanWrapper vWrappedBean = new BeanWrapper(pBeanName, vBean, pCompatibleClass, pSingleton);
                this.mBeanCache.put(vWrappedBean.getBeanDefinition(), vWrappedBean);
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Bean [" + vWrappedBean.getBeanDefinition() + "] was retrieved from cache, singleton = true, wrapper added");
                return vBean;
            }
            vBean = this.createUncachedBean(pBeanName, pClassName, pCompatibleClass);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - New Bean was created");
            BeanWrapper vWrappedBean = new BeanWrapper(pBeanName, vBean, pCompatibleClass, pSingleton);
            this.mBeanCache.put(vWrappedBean.getBeanDefinition(), vWrappedBean);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - New Bean [" + vWrappedBean.getBeanDefinition() + "] was added to cache ");
            return vBean;
        }
        catch (BeanFactoryException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception for bean [" + pBeanName + "]: " + e.getMessage(), e);
        }
    }

    public Object createUncachedBean(String pBeanName, String pClassName, Class pCompatibleClass) throws BeanFactoryException {
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - About to instantiate new bean of type [" + pClassName + "]");
            Class<?> vClass = Class.forName(pClassName);
            if (!pCompatibleClass.isAssignableFrom(vClass)) {
                throw new InvalidClassException("Class requested is of type [" + vClass.getName() + "] and not the expected type [" + pCompatibleClass.getName() + "]");
            }
            Object vBean = vClass.newInstance();
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - New bean [" + vClass.getName() + "] instantiated");
            if ((class$net$za$pwnconsulting$javaconfig$beans$ReflectionBean == null ? (class$net$za$pwnconsulting$javaconfig$beans$ReflectionBean = BeanFactory.class$("net.za.pwnconsulting.javaconfig.beans.ReflectionBean")) : class$net$za$pwnconsulting$javaconfig$beans$ReflectionBean).isAssignableFrom(vClass)) {
                ((ReflectionBean)vBean).setName(pBeanName);
            }
            if ((class$net$za$pwnconsulting$javaconfig$core$ConfigurationAware == null ? (class$net$za$pwnconsulting$javaconfig$core$ConfigurationAware = BeanFactory.class$("net.za.pwnconsulting.javaconfig.core.ConfigurationAware")) : class$net$za$pwnconsulting$javaconfig$core$ConfigurationAware).isAssignableFrom(vClass)) {
                ((ConfigurationAware)vBean).setConfiguration(this.mConfiguration);
            }
            return vBean;
        }
        catch (ClassNotFoundException e) {
            throw new BeanFactoryException("Bean Factory Exception: The bean class specified [" + pClassName + "], [" + pBeanName + "] could not be located", e);
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception for bean [" + pBeanName + "]: " + e.getMessage(), e);
        }
    }

    private synchronized Object getBeanFromCache(String pBeanName, Class pCompatibleClass, Class pIncompatibleClass) {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Trying to retrieve bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] from cache");
        if (pBeanName != null) {
            if (this.mBeanCache.containsKey(BeanWrapper.getBeanDefinition(pBeanName, pCompatibleClass))) {
                return ((BeanWrapper)this.mBeanCache.get(BeanWrapper.getBeanDefinition(pBeanName, pCompatibleClass))).getBean();
            }
        } else {
            Iterator vI = this.mBeanCache.keySet().iterator();
            while (vI.hasNext()) {
                BeanWrapper vBW = (BeanWrapper)this.mBeanCache.get(vI.next());
                if (!pCompatibleClass.isAssignableFrom(vBW.getBean().getClass())) continue;
                if (pIncompatibleClass == null) {
                    return vBW.getBean();
                }
                if (pIncompatibleClass.isAssignableFrom(vBW.getBean().getClass())) continue;
                return vBW.getBean();
            }
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Failed to retrieve bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] from cache");
        return null;
    }

    public synchronized List enumBeans(Class pCompatibleClass, Class pIncompatibleClass) throws BeanFactoryException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Trying to enumerate all beans of type [" + pCompatibleClass.getName() + "] from cache");
        ArrayList<Object> vBeans = new ArrayList<Object>();
        Iterator vI = this.mBeanCache.keySet().iterator();
        while (vI.hasNext()) {
            BeanWrapper vBW = (BeanWrapper)this.mBeanCache.get(vI.next());
            if (!pCompatibleClass.isAssignableFrom(vBW.getBean().getClass())) continue;
            if (pIncompatibleClass == null) {
                vBeans.add(vBW.getBean());
                continue;
            }
            if (pIncompatibleClass.isAssignableFrom(vBW.getBean().getClass())) continue;
            vBeans.add(vBW.getBean());
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - found [" + vBeans.size() + "] beans of type [" + pCompatibleClass.getName() + "] from cache");
        return vBeans;
    }

    private synchronized void removeBeanFromCache(String pBeanName, Class pCompatibleClass, Class pIncompatibleClass) {
        boolean vRemoved;
        block4: {
            block3: {
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Trying to remove bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] from cache");
                vRemoved = false;
                if (pBeanName == null) break block3;
                if (!this.mBeanCache.containsKey(BeanWrapper.getBeanDefinition(pBeanName, pCompatibleClass))) break block4;
                this.mBeanCache.remove(BeanWrapper.getBeanDefinition(pBeanName, pCompatibleClass));
                vRemoved = true;
                break block4;
            }
            Iterator vI = this.mBeanCache.keySet().iterator();
            while (vI.hasNext()) {
                Object vNext = vI.next();
                BeanWrapper vBW = (BeanWrapper)this.mBeanCache.get(vNext);
                if (!pCompatibleClass.isAssignableFrom(vBW.getBean().getClass()) || pIncompatibleClass != null && pIncompatibleClass.isAssignableFrom(vBW.getBean().getClass())) continue;
                this.mBeanCache.remove(vNext);
                vRemoved = true;
                break;
            }
        }
        if (!vRemoved) {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Failed to remove bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] from cache");
        } else {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Removed bean [" + (pBeanName == null ? "<<Singleton>>" : pBeanName) + "], [" + pCompatibleClass.getName() + "] from cache");
        }
    }

    public void populateBean(Object pCommand, Map pValues, Errors pErrors) throws BeanFactoryException {
        this.populateBean(pCommand, pValues, pErrors, "");
    }

    private void populateBean(Object pCommand, Map pValues, Errors pErrors, String pBaseBeanName) throws BeanFactoryException {
        try {
            Method[] vMethods = pCommand.getClass().getMethods();
            block7: for (int i = 0; i < vMethods.length; ++i) {
                Method vMethod = vMethods[i];
                if (!vMethod.getName().startsWith("set") || vMethod.getName().length() <= 3) continue;
                String vAttributeName = vMethod.getName().substring(3);
                if (pValues.containsKey(vAttributeName = Introspector.decapitalize(vAttributeName))) {
                    String[] vParamValues = (String[])pValues.get(vAttributeName);
                    Object vValue = null;
                    Class vDesiredParamType = vMethod.getParameterTypes()[0];
                    try {
                        if (vParamValues != null && vParamValues.length >= 1) {
                            if (this.mCoercions == null) {
                                throw new BeanFactoryException("BeanFactory was not configured correctly - init() was not called as the Coercion object was not instantiated");
                            }
                            if (vParamValues.length > 1 || (class$java$util$List == null ? BeanFactory.class$("java.util.List") : class$java$util$List).isAssignableFrom(vDesiredParamType)) {
                                try {
                                    vDesiredParamType = class$java$lang$String == null ? BeanFactory.class$("java.lang.String") : class$java$lang$String;
                                    Field vField = pCommand.getClass().getField(vAttributeName.toUpperCase() + "_TYPE");
                                    if ((class$java$lang$Class == null ? BeanFactory.class$("java.lang.Class") : class$java$lang$Class).isAssignableFrom(vField.getType())) {
                                        vDesiredParamType = (Class)vField.get(pCommand);
                                    }
                                }
                                catch (NoSuchFieldException e) {
                                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_JAVACONFIG, "No XXX_TYPE static field specified containing class type for contents of attribute [" + vAttributeName + "] - defaulting to [" + (class$java$lang$String == null ? BeanFactory.class$("java.lang.String") : class$java$lang$String).getName() + "]");
                                }
                                vValue = this.mCoercions.coerceStrings(vParamValues, vDesiredParamType);
                            } else {
                                vValue = this.mCoercions.coerceString(vParamValues[0], vDesiredParamType);
                            }
                        }
                        if (BasicLogger.getBasicLogger().isDebugEnabled(this.mLogger)) {
                            boolean vIsBinary = false;
                            if (vValue instanceof String && vValue != null) {
                                byte[] vBytes = ((String)vValue).getBytes();
                                if (vBytes.length > 1024) {
                                    vIsBinary = true;
                                } else {
                                    for (int a = 0; a < vBytes.length; ++a) {
                                        if (vBytes[a] == (char)vBytes[a]) continue;
                                        vIsBinary = true;
                                        break;
                                    }
                                }
                            }
                            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Calling [" + pCommand.getClass() + "].[" + vMethod.getName() + "] with param type [" + vDesiredParamType.getName() + "] and value [" + (vIsBinary ? "<<BINARY>>" : vValue) + "]");
                        }
                        vMethod.invoke(pCommand, vValue);
                    }
                    catch (CoercionException e) {
                        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "Rejecting bad bean property [" + pBaseBeanName + vAttributeName + "] because of [" + e.getMessage() + "]");
                        pErrors.rejectValue(pBaseBeanName + vAttributeName, "000", "Coercion Exception: " + e.getMessage());
                    }
                    continue;
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "--> Looking for nested beans for method [" + vMethod.getName() + "]...");
                Iterator vKeys = pValues.keySet().iterator();
                while (vKeys.hasNext()) {
                    String vKeyName = (String)vKeys.next();
                    if (vKeyName.indexOf(46) <= 0 || !vKeyName.substring(0, vKeyName.indexOf(46)).equals(vAttributeName)) continue;
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "--> Found matching nested bean [" + vAttributeName + "]");
                    Method vGetter = pCommand.getClass().getMethod("get" + vMethod.getName().substring(3), null);
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "--> Found getter [" + vGetter.getName() + "] for matching nested bean [" + vAttributeName + "]");
                    Object vNestedBean = vGetter.invoke(pCommand, null);
                    if (vNestedBean == null) {
                        throw new BeanFactoryException("Nested bean returned by method [" + vGetter.getName() + "] on object [" + pCommand.getClass().getName() + "] is null.  Is it instantiated in the " + "constructor of [" + pCommand.getClass().getName() + "]?");
                    }
                    HashMap vNestedMap = new HashMap();
                    Iterator vNestedKeys = pValues.keySet().iterator();
                    while (vNestedKeys.hasNext()) {
                        String vNestedKeyName = (String)vNestedKeys.next();
                        if (vNestedKeyName.indexOf(46) <= 0 || !vNestedKeyName.substring(0, vNestedKeyName.indexOf(46)).equals(vAttributeName)) continue;
                        String vNestedBeanPropertyName = vNestedKeyName.substring(vNestedKeyName.indexOf(46) + 1);
                        vNestedMap.put(vNestedBeanPropertyName, pValues.get(vNestedKeyName));
                    }
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_JAVACONFIG, "--> Populating nested bean [" + vAttributeName + "] with Map [" + ((Object)vNestedMap).toString() + "]...");
                    String vBaseBeanName = pBaseBeanName == null || pBaseBeanName.equals("") ? "" : pBaseBeanName;
                    vBaseBeanName = vBaseBeanName + vAttributeName + ".";
                    this.populateBean(vNestedBean, vNestedMap, pErrors, vBaseBeanName);
                    continue block7;
                }
            }
        }
        catch (BeanFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception: " + e.getMessage(), e);
        }
    }

    public Map convertBeanToMap(Object pCommand) throws BeanFactoryException {
        try {
            Method[] vMethods = pCommand.getClass().getMethods();
            HashMap<String, Object> vMap = new HashMap<String, Object>();
            for (int i = 0; i < vMethods.length; ++i) {
                Method vMethod = vMethods[i];
                if ((!vMethod.getName().startsWith("get") || vMethod.getName().length() <= 3) && (!vMethod.getName().startsWith("is") || vMethod.getName().length() <= 2)) continue;
                String vAttributeName = vMethod.getName().substring(vMethod.getName().startsWith("get") ? 3 : 2);
                vAttributeName = Introspector.decapitalize(vAttributeName);
                vMap.put(vAttributeName, vMethod.invoke(pCommand, null));
            }
            return vMap;
        }
        catch (Exception e) {
            throw new BeanFactoryException("Bean Factory Exception: " + e.getMessage(), e);
        }
    }

    public String getBeanCacheInfo() {
        StringBuffer vBeanInfo = new StringBuffer();
        Iterator vI = this.mBeanCache.keySet().iterator();
        while (vI.hasNext()) {
            String vKey = (String)vI.next();
            BeanWrapper vBW = (BeanWrapper)this.mBeanCache.get(vKey);
            vBeanInfo.append(vBW.toString()).append("\r\n");
        }
        return vBeanInfo.toString();
    }

    public void shutdown() {
        this.mConfiguration = null;
        this.mBeanCache = null;
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_JAVACONFIG, "BeanFactory [" + this.mBeanFactoryName + "] - Successfully shut down BeanFactory");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

